<?php
session_start();
include 'db.php';

// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Check if the admin is logged in
if (!isset($_SESSION['admin_logged_in'])) {
    header('Location: admin_login.php');
    exit();
}

// Fetch document based on ID
if (isset($_GET['id'])) {
    $id = intval($_GET['id']);
    $query = "SELECT * FROM documents WHERE id = $id";
    $result = mysqli_query($conn, $query);
    $document = mysqli_fetch_assoc($result);
} else {
    header('Location: admin_dashboard.php');
    exit();
}

// Handle file deletion
if (isset($_POST['delete_file'])) {
    $attachment = $_POST['attachment'];
    $target = "uploads/" . $attachment;
    if (file_exists($target)) {
        unlink($target); // Delete the file from the server
    }
    // Remove the deleted file from the attachment list
    $attachments = explode(',', $document['attachment']);
    $updatedAttachments = array_values(array_diff($attachments, [$attachment])); // Reindex the array
    $attachmentsString = implode(',', $updatedAttachments);
    
    $updateQuery = "UPDATE documents SET attachment='$attachmentsString' WHERE id = $id";
    if (!mysqli_query($conn, $updateQuery)) {
        echo "Error: " . mysqli_error($conn);
    }
    header("Location: view_document.php?id=$id");
    exit();
}

// Update document information
if (isset($_POST['update'])) {
    // Validate inputs before proceeding
    $name = $_POST['name'] ?? '';
    $father_name = $_POST['father_name'] ?? '';
    $cnic_no = $_POST['cnic_no'] ?? '';
    $mobile_no = $_POST['mobile_no'] ?? '';
    $address = $_POST['address'] ?? '';
    $document_type = $_POST['document_type'] ?? '';
    $status = $_POST['status'] ?? '';

    // Update the document with the new data
    $updateQuery = "UPDATE documents SET 
        name='$name', 
        father_name='$father_name', 
        cnic_no='$cnic_no', 
        mobile_no='$mobile_no', 
        address='$address', 
        document_type='$document_type',
        status='$status' 
        WHERE id = $id";
    
    if (!mysqli_query($conn, $updateQuery)) {
        echo "Error updating document: " . mysqli_error($conn);
        exit();
    } else {
        header("Location: view_document.php?id=$id");
        exit();
    }
}

// Handle file reupload
if (isset($_POST['reupload_file'])) {
    $oldAttachment = $_POST['old_attachment'];
    $target = "uploads/" . basename($_FILES['new_attachment']['name']);
    
    // Delete old file if it exists
    if (file_exists("uploads/" . $oldAttachment)) {
        unlink("uploads/" . $oldAttachment); // Remove the old file from the server
    }

    // Move the uploaded file to the target directory
    if (move_uploaded_file($_FILES['new_attachment']['tmp_name'], $target)) {
        // Update the attachments list in the database
        $attachmentsArray = explode(',', $document['attachment']);
        $attachmentsArray = array_diff($attachmentsArray, [$oldAttachment]); // Remove the old file from the array
        $attachmentsArray[] = basename($_FILES['new_attachment']['name']); // Add new file
        $attachmentsString = implode(',', $attachmentsArray);

        $updateQuery = "UPDATE documents SET attachment='$attachmentsString' WHERE id = $id";
        if (!mysqli_query($conn, $updateQuery)) {
            echo "Error: " . mysqli_error($conn);
        }
        header("Location: view_document.php?id=$id");
        exit();
    }
}

// Handle new file uploads
if (isset($_POST['upload_file'])) {
    // Check if files were uploaded
    if (isset($_FILES['new_attachments'])) {
        $uploadedFiles = $_FILES['new_attachments'];
        $attachmentsArray = explode(',', $document['attachment']); // Existing attachments

        for ($i = 0; $i < count($uploadedFiles['name']); $i++) {
            if ($uploadedFiles['error'][$i] === UPLOAD_ERR_OK) {
                $target = "uploads/" . basename($uploadedFiles['name'][$i]);
                
                // Move the uploaded file to the target directory
                if (move_uploaded_file($uploadedFiles['tmp_name'][$i], $target)) {
                    // Add the new file to the attachments list
                    $attachmentsArray[] = basename($uploadedFiles['name'][$i]);
                } else {
                    echo "Failed to move uploaded file: " . htmlspecialchars($uploadedFiles['name'][$i]);
                }
            } else {
                echo "Error uploading file: " . htmlspecialchars($uploadedFiles['name'][$i]);
            }
        }

        // Update the attachments list in the database
        $attachmentsString = implode(',', $attachmentsArray);
        $updateQuery = "UPDATE documents SET attachment='$attachmentsString' WHERE id = $id";
        if (!mysqli_query($conn, $updateQuery)) {
            echo "Error: " . mysqli_error($conn);
        }
        header("Location: view_document.php?id=$id");
        exit();
    } else {
        echo "No files selected for upload.";
    }
}
?>




<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>View Document</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <style>
        body {
            background-color: #f8f9fa;
        }
        h1, h2 {
            color: #4CAF50; /* Success color for heading */
        }
        .container {
            margin-top: 30px;
            background-color: #ffffff;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            padding: 20px;
        }
        .btn {
            margin-left: 5px;
        }
        .file-actions {
            display: flex;
            gap: 5px;
        }
        .upload-section {
            margin-top: 30px;
            padding: 20px;
            border: 1px dashed #4CAF50;
            border-radius: 8px;
            background-color: #f1f9f1;
        }
        .upload-section h3 {
            color: #4CAF50;
        }
        .file-upload-input {
            border: 2px dashed #4CAF50;
            border-radius: 5px;
            padding: 10px;
            transition: border-color 0.3s;
        }
        .file-upload-input:focus {
            border-color: #5cb85c;
            outline: none;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1 class="text-center">View Document Details</h1>
        <form method="POST">
            <div class="mb-3">
                <label for="reference_no" class="form-label">Reference No</label>
                <input type="text" class="form-control" name="reference_no" value="<?= $document['reference_no'] ?>" readonly>
            </div>
            <div class="mb-3">
                <label for="name" class="form-label">Name</label>
                <input type="text" class="form-control" name="name" value="<?= $document['name'] ?>" required>
            </div>
            <div class="mb-3">
                <label for="father_name" class="form-label">Father's Name</label>
                <input type="text" class="form-control" name="father_name" value="<?= $document['father_name'] ?>" required>
            </div>
            <div class="mb-3">
                <label for="cnic_no" class="form-label">CNIC No</label>
                <input type="text" class="form-control" name="cnic_no" value="<?= $document['cnic_no'] ?>" required>
            </div>
            <div class="mb-3">
                <label for="mobile_no" class="form-label">Mobile No</label>
                <input type="text" class="form-control" name="mobile_no" value="<?= $document['mobile_no'] ?>" required>
            </div>
            <div class="mb-3">
                <label for="address" class="form-label">Address</label>
                <input type="text" class="form-control" name="address" value="<?= $document['address'] ?>" required>
            </div>
            <div class="mb-3">
                <label for="document_type" class="form-label">Document Type</label>
                <input type="text" class="form-control" name="document_type" value="<?= $document['document_type'] ?>" required>
            </div>
            <div class="mb-3">
                <label for="status" class="form-label">Status</label>
                <select class="form-select" name="status">
                    <option value="Pending" <?= $document['status'] == 'Pending' ? 'selected' : '' ?>>Pending</option>
                    <option value="Draft" <?= $document['status'] == 'Draft' ? 'selected' : '' ?>>Draft</option>
                    <option value="Completed" <?= $document['status'] == 'Completed' ? 'selected' : '' ?>>Completed</option>
                </select>
            </div>
            <button type="submit" name="update" class="btn btn-primary">Update Document</button>
            <a href="admin_dashboard.php" class="btn btn-secondary">Back to Dashboard</a>
        </form>

        <!-- Section for displaying all uploaded files -->
        <h2 class="mt-5">Uploaded Files</h2>
        <ul class="list-group">
            <?php
            if ($document['attachment']) {
                $attachmentsArray = explode(',', $document['attachment']);
                foreach ($attachmentsArray as $file) {
                    if ($file) {
                        echo '<li class="list-group-item d-flex justify-content-between align-items-center">';
                        echo htmlspecialchars($file);
                        echo '<div class="d-flex align-items-center">';
                        // Reupload button
                        echo '<form method="POST" enctype="multipart/form-data" class="d-inline me-2">';
                        echo '<input type="hidden" name="old_attachment" value="'.htmlspecialchars($file).'">';
                        echo '<input type="file" name="new_attachment" class="form-control me-2" required>';
                        echo '<button type="submit" name="reupload_file" class="btn btn-warning btn-sm">Reupload</button>';
                        echo '</form>';
                        // Delete button
                        echo '<form method="POST" action="view_document.php?id='.$document['id'].'" class="d-inline">';
                        echo '<input type="hidden" name="attachment" value="'.htmlspecialchars($file).'">';
                        echo '<button type="submit" name="delete_file" class="btn btn-danger btn-sm">Delete</button>';
                        echo '</form>';
                        // View button
                        echo '<a href="uploads/'.htmlspecialchars($file).'" target="_blank" class="btn btn-success btn-sm ms-2">View</a>';
                        echo '</div>';
                        echo '</li>';
                    }
                }
            } else {
                echo '<li class="list-group-item">No files uploaded yet.</li>';
            }
            ?>
        </ul>

        <!-- Form to upload new files -->
        <div class="upload-section">
            <h3>Add New Files</h3>
            <form method="POST" enctype="multipart/form-data" class="mt-3">
                <div class="mb-3">
                    <input type="file" class="file-upload-input" name="new_attachments[]" multiple required>
                </div>
                <button type="submit" name="upload_file" class="btn btn-primary">Upload</button>
            </form>
        </div>
    </div>
</body>
</html>