<?php
session_start();
include 'db.php';

// Check if the token is provided
if (isset($_GET['token']) && isset($_SESSION['file_token'][$_GET['token']])) {
    $file = $_SESSION['file_token'][$_GET['token']]; // Get the associated file
    $file_path = 'uploads/' . basename($file); // Construct the full path

    // Check if the file exists
    if (file_exists($file_path)) {
        // Set headers for file display
        header('Content-Type: application/pdf'); // Change MIME type if necessary
        header('Content-Disposition: inline; filename="' . basename($file) . '"');
        header('Content-Length: ' . filesize($file_path));
        
        // Read the file and send it to the output buffer
        readfile($file_path);
        exit;
    } else {
        echo "File not found.";
        exit;
    }
} else {
    echo "Invalid or expired token.";
    exit;
}
?>
