<?php
session_start();
include 'db.php';

// Handle form submission for verification
$document_info = null;
$files = [];
$verification_status = '';
$error_message = '';
$success_message = '';

// Check if ref_no is in the URL
if (isset($_GET['ref_no'])) {
    $reference_no = $_GET['ref_no'];

    // Fetch the document based on Reference No, only if status is 'Completed'
    $query = "SELECT * FROM documents WHERE reference_no = '$reference_no' AND status = 'Completed'";
    $result = mysqli_query($conn, $query);

    if (!$result) {
        die("Query failed: " . mysqli_error($conn)); // Display the error
    }

    if (mysqli_num_rows($result) > 0) {
        $document_info = mysqli_fetch_assoc($result);
        $verification_status = 'verified'; // Document found
        $success_message = 'User details successfully verified. In case of any issues, contact us on WhatsApp: +92-301-517 3351'; // Success message

        // Fetch associated files from the attachment field, remove empty entries
        if ($document_info['attachment']) {
            $files = array_filter(explode(',', $document_info['attachment']), function($file) {
                return !empty(trim($file)); // Remove empty or blank space entries
            });
        }
    } else {
        $verification_status = 'not_found'; // No document found
        $error_message = 'Error: Reference No data not found or status is not completed.'; // Error message
    }
}

// Handle form submission for manual verification
if (isset($_POST['verify'])) {
    $reference_no = $_POST['reference_no'];

    // Fetch the document based on Reference No, only if status is 'Completed'
    $query = "SELECT * FROM documents WHERE reference_no = '$reference_no' AND status = 'Completed'";
    $result = mysqli_query($conn, $query);

    if (!$result) {
        die("Query failed: " . mysqli_error($conn)); // Display the error
    }

    if (mysqli_num_rows($result) > 0) {
        $document_info = mysqli_fetch_assoc($result);
        
        $success_message = 'User details successfully verified. In case of any issues, contact us on WhatsApp: +92-301-5173351'; // Success message

        // Fetch associated files from the attachment field, remove empty entries
        if ($document_info['attachment']) {
            $files = array_filter(explode(',', $document_info['attachment']), function($file) {
                return !empty(trim($file)); // Remove empty or blank space entries
            });
        }
    } else {
        $verification_status = 'not_found'; // No document found
        $error_message = 'Error: Reference No data not found or status is not completed.'; // Error message
    }
}

// Include the header
include 'header.php'; // Include your header here

// Display the files with correct serial number, ignoring empty files
if (!empty($files)) {
    echo "<table>";
    echo "<tr><th>Sr No</th><th>File Name</th></tr>";
    $serial_number = 1;
    foreach ($files as $file) {
        echo "<tr><td>" . $serial_number++ . "</td><td>" . htmlspecialchars($file) . "</td></tr>";
    }
    echo "</table>";
} else {
    echo "No files available.";
}
?>




<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Document Verification</title>
    <link rel="stylesheet" href="styles.css"> <!-- Link to your CSS file for styles -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdf-lib/1.17.1/pdf-lib.min.js"></script>
    <style>
        /* Your existing styles */
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            padding: 10px;
        }

        .verify-bar {
            background-color: #4CAF50; /* Green */
            color: white;
            text-align: center;
            padding: 10px 0;
            margin-bottom: 20px;
            border-radius: 5px;
            margin-top: 80px;
        }

        .verified-stamp {
            position: absolute;
            bottom: 50px; /* Positioning the stamp at the bottom */
            right: 150px; /* Positioning the stamp to the left */
            opacity: 10; /* Reduced opacity */
            z-index: 10; /* Ensure it's above other content */
            width: 100px; /* Adjust the size as needed */
        }

        /* Additional styles for your sections */
        .user-data, .attachment-section {
            padding: 20px;
            background-color: white;
            border-radius: 5px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            position: relative; /* To position stamp image */
            margin-top: 20px;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px
            padding: 10px;
        }

        .table th, .table td {
            border: 1px solid #ddd;
            padding: 8px;
        }

        .table th {
            background-color: #f2f2f2;
        }

        .verified {
            background-color: #d4edda; /* Light green background */
            color: #155724; /* Dark green text */
            padding: 5px;
            border-radius: 5px;
            text-align: center;
        }

        .error-message {
            background-color: #f8d7da; /* Light red background */
            color: #721c24; /* Dark red text */
            padding: 10px;
            border: 1px solid #f5c6cb;
            border-radius: 5px;
            margin-bottom: 20px;
        }

        .success-message {
            background-color: #d4edda; /* Light green background */
            color: #155724; /* Dark green text */
            padding: 10px;
            border: 1px solid #c3e6cb;
            border-radius: 5px;
            margin-bottom: 20px;
        }

        .search-bar {
            margin-bottom: 20px;
            display: flex;
            justify-content: center; /* Center the search bar */
        }

        .search-bar input[type="text"] {
            padding: 10px;
            border: 1px solid #ccc;
            border-radius: 5px;
            width: 250px; /* Width of the input */
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
            transition: border 0.3s, box-shadow 0.3s; /* Transition for hover effect */
        }

        .search-bar input[type="text"]:focus {
            border: 1px solid #4CAF50; /* Change border color on focus */
            box-shadow: 0 0 5px rgba(76, 175, 80, 0.5); /* Shadow effect on focus */
            outline: none; /* Remove default outline */
        }

        .search-bar button {
            padding: 10px 15px;
            border: none;
            border-radius: 5px;
            background-color: #4CAF50; /* Button color */
            color: white;
            margin-left: 10px; /* Space between input and button */
            cursor: pointer; /* Pointer cursor on hover */
            transition: background-color 0.3s; /* Transition for hover effect */
        }

        .search-bar button:hover {
            background-color: #45a049; /* Darker green on hover */
        }

        .attachment-table {
            margin-top: 20px;
            width: 100%;
            border-collapse: collapse;
            
        }

        .attachment-table th, .attachment-table td {
            border: 1px solid #ddd;
            padding: 8px;
        }

        .attachment-table th {
            background-color: #4CAF50;
            text-align: left;
            color: white;
        }

        .attachment-section .action-button {
            background-color: #4CAF50; /* Button color */
            color: white;
            border: none;
            padding: 5px 10px;
            border-radius: 5px;
            cursor: pointer;
            transition: background-color 0.3s; /* Transition for hover effect */
        }

        .attachment-section .action-button:hover {
            background-color: #45a049; /* Darker green on hover */
        }

        .attachment-section p {
            margin: 10px 0;
        }

        .note {
            background-color: #f8d7da; /* Light red background */
            color: #721c24; /* Dark red text */
            padding: 10px;
            border: 1px solid #f5c6cb;
            border-radius: 5px;
            margin-top: 20px;
        }
        .status-column {
            background-color: #d4edda; /* Light green background */
            color: #155724; /* Dark green text */
            padding: 5px;
            border-radius: 5px;
            text-align: left;
        }
    </style>
</head>
<body>

<div class="verify-bar">
    <h2>MNSV Online Document Verification System</h2>
</div>

<!-- Search Bar -->
<div class="search-bar">
    <form id="searchForm" method="GET" action="">
        <input type="text" name="ref_no" id="ref_no" placeholder="Enter Reference No" required>
        <button type="submit">Verify</button>
    </form>
</div>

<div class="user-data">
    <?php if ($success_message): ?>
        <div class="success-message"><?= $success_message ?></div>
    <?php endif; ?>

    <?php if ($error_message): ?>
        <div class="error-message"><?= $error_message ?></div>
    <?php endif; ?>

    <?php if ($document_info): ?>
        <img src="images/stamp.png" alt="Verified Stamp" class="verified-stamp">
        
        <h3>User Details</h3>
        <table class="table">
            <tr>
                <th>Refrence No</th>
                <td><?= htmlspecialchars($document_info['reference_no']) ?></td>
            </tr>
            <tr>
                <th>Name</th>
                <td><?= htmlspecialchars($document_info['name']) ?></td>
            </tr>
            <tr>
                <th>Father Name</th>
                <td><?= htmlspecialchars($document_info['father_name']) ?></td>
            </tr>
            <tr>
                <th>CNIC No</th>
                <td><?= htmlspecialchars($document_info['cnic_no']) ?></td>
            </tr>
            <tr>
                <th>Mobile No</th>
                <td><?= htmlspecialchars($document_info['mobile_no']) ?></td>
            </tr>
            <tr>
                <th>Document Type</th>
                <td><?= htmlspecialchars($document_info['document_type']) ?></td>
            </tr>

            <tr>
                <th>Address</th>
                <td><?= htmlspecialchars($document_info['address']) ?></td>
            </tr>
            <tr>
                <th>Status</th>
                <td class="status-column"><?= ucfirst($verification_status) ?></td>
            </tr>
            
        </table>
    <?php endif; ?>
</div>

<!-- Documents Section -->
<div class="attachment-section">
    <h3>Documents</h3>
    <?php if ($files): ?>
        <table class="attachment-table">
            <tr>
                <th>Serial No</th>
                <th>Files</th>
                <th>Action</th>
            </tr>
            <?php foreach ($files as $index => $file): ?>
                <tr>
                    <td><?= $index + 1 ?></td>
                    <td><?= htmlspecialchars($file) ?></td>
                    <td><button class="action-button" onclick="viewFile('<?= htmlspecialchars($file) ?>', '<?= htmlspecialchars($document_info['reference_no']) ?>')">View</button></td>

                </tr>
            <?php endforeach; ?>
        </table>
    <?php else: ?>
        <p>No attachments found for this document.</p>
    <?php endif; ?>
</div>

<!-- Note Section -->
<div class="note">
    <p>Please ensure that the document you have in hand matches the attachment on the verification portal. If you have any queries, you can contact us on WhatsApp at +92-301-517 3351.</p>
</div>
<script>
    async function viewFile(file, referenceNo) {
        const url = `uploads/${file}`;

        // Fetch the PDF file
        const response = await fetch(url);
        const pdfData = await response.arrayBuffer();

        // Load the PDF document
        const pdfDoc = await PDFLib.PDFDocument.load(pdfData);

        // Embed the watermark image
        const pngUrl = 'images/stamp.png'; // Path to the watermark image
        const pngImageBytes = await fetch(pngUrl).then(res => res.arrayBuffer());
        const pngImage = await pdfDoc.embedPng(pngImageBytes);
        const pngDims = pngImage.scale(0.5); // Scale the watermark image

        // Add a watermark to each page
        const pages = pdfDoc.getPages();
        pages.forEach(page => {
            const pageWidth = page.getWidth();
            const pageHeight = page.getHeight();

            // Calculate center position for watermark
            const watermarkX = (pageWidth - pngDims.width) / 2;
            const watermarkY = (pageHeight - pngDims.height) / 2;

            // Draw the watermark with rotation based on orientation
            if (pageWidth > pageHeight) { // Landscape orientation
                page.save(); // Save the current drawing state
                page.translate(pageWidth / 2, pageHeight / 2); // Move to center of the page
                page.rotate(-Math.PI / 2); // Rotate 90 degrees counter-clockwise
                page.drawImage(pngImage, {
                    x: -pngDims.width / 2, // Center horizontally
                    y: -pngDims.height / 2, // Center vertically
                    width: pngDims.width,
                    height: pngDims.height,
                    opacity: 0.3,
                });
                page.restore(); // Restore the previous drawing state
            } else { // Portrait orientation
                page.drawImage(pngImage, {
                    x: watermarkX,
                    y: watermarkY,
                    width: pngDims.width,
                    height: pngDims.height,
                    opacity: 0.3,
                });
            }
        });

        // Serialize the PDF document to bytes
        const pdfBytes = await pdfDoc.save();

        // Create a blob URL (for viewing)
        const blob = new Blob([pdfBytes], { type: 'application/pdf' });
        const blobUrl = URL.createObjectURL(blob);

        // Open the modified PDF in a new tab
        const newTab = window.open(blobUrl, '_blank');
        if (newTab) {
            newTab.addEventListener('beforeunload', () => {
                URL.revokeObjectURL(blobUrl); // Clean up
            });
        } else {
            alert("Please allow popups for this website");
        }
    }
</script>











</body>
</html>
