<?php
// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Start the session
session_start();

// Include database connection
require_once 'db.php'; // Make sure to include your DB connection file

// Check if admin is logged in
if (!isset($_SESSION['admin_logged_in']) || !isset($_SESSION['admin_id'])) {
    header('Location: admin_login.php'); // Redirect to login page if not logged in
    exit();
}

// Get the admin ID from session
$admin_id = $_SESSION['admin_id'];

// Fetch admin details from the database
$query = "SELECT id, username, name, email, password FROM admins WHERE id = ?";
$stmt = mysqli_prepare($conn, $query);

mysqli_stmt_bind_param($stmt, "i", $admin_id);
mysqli_stmt_execute($stmt);

// Bind the result variables
mysqli_stmt_bind_result($stmt, $id, $username, $name, $email, $password);
mysqli_stmt_fetch($stmt); // Fetch the result

// Check if the admin exists
if (isset($id)) {
    // Fetch the admin data
    $admin = [
        'id' => $id,
        'username' => $username,
        'name' => $name,
        'email' => $email,
        'password' => $password
    ];
} else {
    die("Admin not found.");
}

// Update admin details if form is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Update name
    if (isset($_POST['update_name'])) {
        $new_name = $_POST['name'];
        
        $update_query = "UPDATE admins SET name = ? WHERE id = ?";
        $update_stmt = mysqli_prepare($conn, $update_query);
        mysqli_stmt_bind_param($update_stmt, "si", $new_name, $admin_id);
        mysqli_stmt_execute($update_stmt);
        
        echo "<script>alert('Name updated successfully!');</script>";
    }

    // Change password
    if (isset($_POST['change_password'])) {
        $current_password = $_POST['current_password'];
        $new_password = $_POST['new_password'];
        $confirm_password = $_POST['confirm_password'];

        if (password_verify($current_password, $admin['password'])) {
            if ($new_password === $confirm_password) {
                $new_hashed_password = password_hash($new_password, PASSWORD_DEFAULT);

                $update_query = "UPDATE admins SET password = ? WHERE id = ?";
                $update_stmt = mysqli_prepare($conn, $update_query);
                mysqli_stmt_bind_param($update_stmt, "si", $new_hashed_password, $admin_id);
                mysqli_stmt_execute($update_stmt);

                echo "<script>alert('Password updated successfully!');</script>";
            } else {
                echo "<script>alert('New passwords do not match.');</script>";
            }
        } else {
            echo "<script>alert('Current password is incorrect.');</script>";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Profile</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Roboto', sans-serif;
            background-color: #f8f9fa; /* Light background color */
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 800px; /* Limit max width for larger screens */
            margin: 20px auto; /* Center the container */
            background: white; /* White background for the container */
            border-radius: 10px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
            padding: 30px;
            transition: box-shadow 0.3s;
        }
        .container:hover {
            box-shadow: 0 8px 40px rgba(0, 0, 0, 0.2); /* Hover effect */
        }
        h1 {
            margin-bottom: 20px;
            color: #007bff; /* Blue color for the title */
            text-align: center;
        }
        h2 {
            color: #495057; /* Darker color for section headers */
            margin-bottom: 10px;
        }
        p {
            color: #6c757d; /* Light gray color for paragraph text */
        }
        form {
            margin: 20px 0;
        }
        label {
            margin-bottom: 5px;
            font-weight: bold;
            color: #495057; /* Darker color for labels */
        }
        input[type="text"],
        input[type="password"] {
            width: calc(100% - 22px);
            padding: 10px;
            margin-bottom: 10px;
            border: 1px solid #ced4da;
            border-radius: 5px;
            transition: border-color 0.3s;
        }
        input[type="text"]:focus,
        input[type="password"]:focus {
            border-color: #007bff; /* Change border color on focus */
            outline: none; /* Remove default outline */
        }
        input[type="submit"] {
            background: #28a745; /* Green color for buttons */
            color: white;
            border: none;
            border-radius: 5px;
            padding: 10px;
            cursor: pointer;
            width: 100%;
            transition: background 0.3s, transform 0.2s;
        }
        input[type="submit"]:hover {
            background: #218838; /* Darker green on hover */
            transform: translateY(-1px); /* Lift effect */
        }
        .back-button {
            background: #007bff; /* Blue color for back button */
            margin-top: 10px;
            display: inline-block;
            padding: 10px;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            transition: background 0.3s;
            text-align: center;
            width: 100%; /* Full width */
        }
        .back-button:hover {
            background: #0056b3; /* Darker blue on hover */
        }
        /* Responsive design */
        @media (max-width: 600px) {
            .container {
                padding: 20px; /* Less padding on small screens */
            }
            h1 {
                font-size: 24px; /* Smaller font size for title */
            }
        }
    </style>
</head>
<body>
    <?php include 'header.php'; ?> <!-- Include header -->

    <div class="container">
        <h1>Admin Profile</h1>
        
        <!-- Display current admin details -->
        <h2>Current Details</h2>
        <p><strong>Name:</strong> <?php echo htmlspecialchars($admin['name']); ?></p>
        <p><strong>Email:</strong> <?php echo htmlspecialchars($admin['email']); ?></p>

        <!-- Form to update name -->
        <h2>Update Name</h2>
        <form action="" method="post">
            <label for="name">New Name:</label>
            <input type="text" name="name" required>
            <input type="submit" name="update_name" value="Update Name">
        </form>

        <!-- Form to change password -->
        <h2>Change Password</h2>
        <form action="" method="post">
            <label for="current_password">Current Password:</label>
            <input type="password" name="current_password" required>
            <br>
            <label for="new_password">New Password:</label>
            <input type="password" name="new_password" required>
            <br>
            <label for="confirm_password">Confirm New Password:</label>
            <input type="password" name="confirm_password" required>
            <br>
            <input type="submit" name="change_password" value="Change Password">
        </form>

        <!-- Back to Dashboard button -->
        <a href="admin_dashboard.php" class="back-button">Back to Dashboard</a>
    </div>
</body>
</html>
