<?php
session_start();
include 'db.php';

// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

if (!isset($_SESSION['admin_logged_in'])) {
    header('Location: admin_login.php');
    exit();
}

// Function to generate a unique ID of specified length
function generateUniqueID($length = 6) {
    return substr(str_shuffle(str_repeat('0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ', ceil($length / 36))), 1, $length);
}

// Function to check if a reference number already exists in the database
function isReferenceNoExists($reference_no, $conn) {
    $query = "SELECT reference_no FROM documents WHERE reference_no = '$reference_no'";
    $result = mysqli_query($conn, $query);
    return mysqli_num_rows($result) > 0; // Return true if reference_no exists
}

// Generate a new unique ID only if it's not already set in the session
if (!isset($_SESSION['reference_no'])) {
    do {
        $unique_id = generateUniqueID(6); // Generate a new unique ID
        $reference_no = "MNSV-" . $unique_id; // Create a new reference number
    } while (isReferenceNoExists($reference_no, $conn)); // Check if the reference number already exists

    $_SESSION['reference_no'] = $reference_no; // Store the reference number in session
} else {
    $reference_no = $_SESSION['reference_no']; // Use the reference number from session
}

// URL for QR code
$base_url = "https://verify.mnsvtranslator.com/user_verify.php";
$full_url = $base_url . "?ref_no=" . $reference_no; // Full URL with reference number
$qr_code_path = "qrcodes/" . $reference_no . ".png";

// Include the PHP QR Code library
include 'phpqrcode/qrlib.php';

// Set QR code size and quality
$size = 10; 
$margin = 2; 

// Generate new QR code if it's not already generated
if (!file_exists($qr_code_path)) {
    QRcode::png($full_url, $qr_code_path, QR_ECLEVEL_L, $size, $margin);
}

// Fetch user details based on CNIC
$userDetails = [];
$error = '';

if (isset($_POST['fetch_user'])) {
    $cnic_no = $_POST['cnic_no'];
    $cnic_no = mysqli_real_escape_string($conn, $cnic_no); // Sanitize input
    $query = "SELECT name, father_name, mobile_no, address FROM users WHERE cnic_no = '$cnic_no'";
    
    $result = mysqli_query($conn, $query);
    if ($result && mysqli_num_rows($result) > 0) {
        $userDetails = mysqli_fetch_assoc($result);
    } else {
        $error = "User not found. Please enter details manually.";
    }
}

// Handle document submission
if (isset($_POST['submit'])) {
    $name = mysqli_real_escape_string($conn, $_POST['name']);
    $father_name = mysqli_real_escape_string($conn, $_POST['father_name']);
    $cnic_no = mysqli_real_escape_string($conn, $_POST['cnic_no']);
    $mobile_no = mysqli_real_escape_string($conn, $_POST['mobile_no']);
    $address = mysqli_real_escape_string($conn, $_POST['address']);
    $document_type = mysqli_real_escape_string($conn, $_POST['document_type']); // New field
    $status = mysqli_real_escape_string($conn, $_POST['status']); // Capture the status from the form

    $uploadSuccess = true; 
    $attachments = []; 

    // Only allow uploads if the status is 'Completed'
    if ($status === 'Completed') {
        if (isset($_FILES['attachment'])) {
            for ($i = 0; $i < count($_FILES['attachment']['name']); $i++) {
                if ($_FILES['attachment']['error'][$i] == 0) {
                    $attachment = $_FILES['attachment']['name'][$i];
                    $target = "uploads/" . basename($attachment);

                    // Move the uploaded file
                    if (move_uploaded_file($_FILES['attachment']['tmp_name'][$i], $target)) {
                        $attachments[] = $attachment; 
                    } else {
                        $uploadSuccess = false; 
                    }
                }
            }
        }
    }

    // Insert document data into the database if uploads were successful or not needed
    if ($uploadSuccess) {
        $attachmentsString = ($status === 'Completed') ? implode(',', $attachments) : ''; // Only store attachments if status is 'Completed'
        $insertQuery = "INSERT INTO documents (reference_no, name, father_name, cnic_no, mobile_no, address, attachment, document_type, status) 
                        VALUES ('$reference_no', '$name', '$father_name', '$cnic_no', '$mobile_no', '$address', '$attachmentsString', '$document_type', '$status')"; // Include status value
        
        if (mysqli_query($conn, $insertQuery)) {
            $uploadSuccessMessage = true; 
            
            // Unset the reference number after successful submission to generate a new one on reload
            unset($_SESSION['reference_no']);
            
            // Redirect to admin_dashboard.php after successful submission
            header('Location: admin_dashboard.php');
            exit();
        } else {
            $error = "Database error: " . mysqli_error($conn);
        }
    } else {
        $error = "Failed to upload some files. Please try again.";
    }
}

// Include the header
include 'header.php'; // Include your header here
?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Add Document</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <style>
        body {
            background-color: #f8f9fa;
            margin-top: 100px;
        }
        .container {
            margin-top: 100px;
        }
        .form-container, .qr-container {
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            background-color: #ffffff;
            padding: 20px;
            margin-bottom: 20px; /* Added margin for spacing */
        }
        .qr-container {
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            text-align: center; /* Center text in QR container */
        }
        .preview {
            margin-top: 10px;
        }
        .file-preview {
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-bottom: 10px;
            padding: 5px;
            border: 1px solid #ccc;
            border-radius: 5px;
        }
        .qr-button {
            margin-top: 10px; /* Space between QR image and button */
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="row">
            <div class="col-md-8">
                <div class="form-container mt-4">
                    <h2>Add New Document</h2>
                    <?php if ($error): ?>
                        <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
                    <?php endif; ?>
                    <form method="POST" enctype="multipart/form-data" id="uploadForm">
                        <div class="mb-3">
                            <label for="reference_no" class="form-label">Reference No</label>
                            <input type="text" class="form-control" name="reference_no" value="<?= htmlspecialchars($reference_no) ?>" readonly>
                        </div>
                        <div class="mb-3">
                            <label for="cnic_no" class="form-label">CNIC No</label>
                            <input type="text" class="form-control" name="cnic_no" required onchange="fetchUserDetails()">
                        </div>
                        <button type="button" class="btn btn-secondary mb-3" onclick="fetchUserDetails()">Fetch User Details</button>

                        <?php if (!empty($userDetails)): ?>
                            <!-- Display fetched user details -->
                            <div class="mb-3">
                                <label for="name" class="form-label">Name</label>
                                <input type="text" class="form-control" name="name" value="<?= htmlspecialchars($userDetails['name']) ?>" required>
                            </div>
                            <div class="mb-3">
                                <label for="father_name" class="form-label">Father Name</label>
                                <input type="text" class="form-control" name="father_name" value="<?= htmlspecialchars($userDetails['father_name']) ?>" required>
                            </div>
                            <div class="mb-3">
                                <label for="mobile_no" class="form-label">Mobile No</label>
                                <input type="text" class="form-control" name="mobile_no" value="<?= htmlspecialchars($userDetails['mobile_no']) ?>" required>
                            </div>
                            <div class="mb-3">
                                <label for="address" class="form-label">Address</label>
                                <input type="text" class="form-control" name="address" value="<?= htmlspecialchars($userDetails['address']) ?>" required>
                            </div>
                        <?php else: ?>
                            <!-- Manually enter user details -->
                            <div class="mb-3">
                                <label for="name" class="form-label">Name</label>
                                <input type="text" class="form-control" name="name" required>
                            </div>
                            <div class="mb-3">
                                <label for="father_name" class="form-label">Father Name</label>
                                <input type="text" class="form-control" name="father_name" required>
                            </div>
                            <div class="mb-3">
                                <label for="mobile_no" class="form-label">Mobile No</label>
                                <input type="text" class="form-control" name="mobile_no" required>
                            </div>
                            <div class="mb-3">
                                <label for="address" class="form-label">Address</label>
                                <input type="text" class="form-control" name="address" required>
                            </div>
                        <?php endif; ?>

                        <div class="mb-3">
                            <label for="document_type" class="form-label">Document Type</label>
                            <input type="text" class="form-control" name="document_type" required>
                        </div>

                        <div class="mb-3">
                            <label for="status" class="form-label">Status</label>
                            <select class="form-select" name="status" required>
                                <option value="Draft">Draft</option>
                                <option value="Pending">Pending</option>
                                <option value="Processing">Processing</option>
                                <option value="Completed">Completed</option>
                            </select>
                        </div>

                        <div class="mb-3">
                            <label for="attachment" class="form-label">Attachments</label>
                            <input type="file" class="form-control" name="attachment[]" multiple onchange="previewFiles()">
                            <div class="preview" id="filePreview"></div>
                        </div>
                        
                        <button type="submit" name="submit" class="btn btn-primary">Submit</button>
                    </form>
                </div>
            </div>
            <div class="col-md-4">
                <div class="qr-container mt-4">
                    <h3>QR Code</h3>
                    <img src="<?= htmlspecialchars($qr_code_path) ?>" alt="QR Code" width="200">
                    <a href="<?= htmlspecialchars($qr_code_path) ?>" class="btn btn-success qr-button" download>Download QR Code</a>
                </div>
            </div>
        </div>
    </div>

    <script>
    
    
        function fetchUserDetails() {
            const cnicNo = document.querySelector('input[name="cnic_no"]').value;
            if (!cnicNo) {
                alert('Please enter a CNIC number.');
                return;
            }

            const xhr = new XMLHttpRequest();
            xhr.open('POST', 'fetch_user.php', true);
            xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
            xhr.onreadystatechange = function () {
                if (xhr.readyState === XMLHttpRequest.DONE) {
                    if (xhr.status === 200) {
                        const userDetails = JSON.parse(xhr.responseText);
                        if (userDetails) {
                            document.querySelector('input[name="name"]').value = userDetails.name;
                            document.querySelector('input[name="father_name"]').value = userDetails.father_name;
                            document.querySelector('input[name="mobile_no"]').value = userDetails.mobile_no;
                            document.querySelector('input[name="address"]').value = userDetails.address;
                        } else {
                            alert('User not found. Please enter details manually.');
                        }
                    } else {
                        alert('Error fetching user details. Please try again.');
                    }
                }
            };
            xhr.send('cnic_no=' + encodeURIComponent(cnicNo));
        }

        function previewFiles() {
    const filePreview = document.getElementById('filePreview');
    filePreview.innerHTML = ''; // Clear existing previews

    const files = document.querySelector('input[type="file"]').files;
    for (let i = 0; i < files.length; i++) {
        const fileName = files[i].name;
        const fileDiv = document.createElement('div');
        fileDiv.className = 'file-preview';
        fileDiv.innerHTML = `
            ${fileName}
            <button type="button" onclick="removeFile(this)">Remove</button>
        `;
        filePreview.appendChild(fileDiv);
    }
}

function removeFile(button) {
    const filePreview = document.getElementById('filePreview');
    const fileDiv = button.parentElement; // Get the parent div of the button
    filePreview.removeChild(fileDiv); // Remove the file div
}
    </script>
</body>
</html>